
//
// To jest przykadowy kod z podrozdziau 17.7 Wskaniki na obiekty klas ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <vector>

//------------------------------------------------------------------------------

// Bardzo uproszczony wektor liczb typu double.
class vector {
    int sz;            // rozmiar
    double* elem;      // wskanik na elementy
public:
    vector(int s) :sz(s), elem(new double[s]) { } // konstruktor
    ~vector() { delete[] elem; }                  // destruktor

    int size() const { return sz; }               // biecy rozmiar wektora

    double get(int n) { return elem[n]; }         // dostp: odczyt
    void set(int n, double v) { elem[n]=v; }      // dostp: zapis
};

//------------------------------------------------------------------------------

vector* f(int s)
{
    vector v(s);
    vector* p = new vector(s); // Alokacja wektora w obszarze pamici wolnej.
    // ...
    *p = v;                    // Kopiowanie danych do wektora poprzez wskanik.
    return p;
}

//------------------------------------------------------------------------------

void ff()
{
    vector* q = f(4);
    vector vv = *q;            // Kopiowanie danych z wektora poprzez wskanik.
    // ...
    delete q;                  // Usunicie wektora z pamici wolnej.
}

//------------------------------------------------------------------------------

int main()
{
    int     s = 100;
    vector* p = new vector(s); // Alokacja wektora w obszarze pamici wolnej.
    delete p;                  // dealokacja

    // Przykad z uyciem standardowego wektora z biblioteki STL.
    {
        using std::vector;

        vector< vector<double> >* p
            = new vector<vector<double> > (10);
        delete p;

        vector< vector< vector<double> > >* q
            = new vector<vector<vector<double> > > (20);
        delete q;
    }

    // Wszystkie klasy obsuguj operator . (kropka) umoliwiajcy uzyskanie dostpu do skadowych.
    {
        vector v(4);
        int x = v.size();
        double d = v.get(3);
    }

    // Wszystkie klasy obsuguj operator -> (strzaka) umoliwiajcy uzyskanie dostpu do skadowych.
    {
        vector* p = new vector(4);
        int x = p->size();
        double d = p->get(3);
    }
}

//------------------------------------------------------------------------------
